import SwiftUI

struct SurveyAccessView: View {
    @State private var showingSurvey = false
    @State private var showingCuriosityMode = false
    @State private var showingDataManagement = false
    @StateObject private var surveyIntegration = SurveyIntegrationService()
    
    var body: some View {
        VStack(spacing: 12) {
            // Survey status indicator
            HStack {
                Image(systemName: surveyIntegration.isDataAvailable ? "checkmark.circle.fill" : "exclamationmark.circle.fill")
                    .foregroundColor(surveyIntegration.isDataAvailable ? .green : .orange)
                
                Text(surveyIntegration.isDataAvailable ? "Survey Complete" : "Survey Needed")
                    .font(.caption)
                    .foregroundColor(.primary)
                
                Spacer()
            }
            
            // Action buttons
            HStack(spacing: 8) {
                Button("Survey") {
                    showingSurvey = true
                }
                .buttonStyle(.bordered)
                .font(.caption2)
                
                if surveyIntegration.isDataAvailable {
                    Button("Explore") {
                        showingCuriosityMode = true
                    }
                    .buttonStyle(.bordered)
                    .font(.caption2)
                    
                    Button("Data") {
                        showingDataManagement = true
                    }
                    .buttonStyle(.bordered)
                    .font(.caption2)
                }
            }
        }
        .padding()
        .background(Color.gray)
        .cornerRadius(12)
        .onAppear {
            surveyIntegration.refreshData()
        }
        .sheet(isPresented: $showingSurvey) {
            SurveyView()
                .onDisappear {
                    surveyIntegration.refreshData()
                }
        }
        .sheet(isPresented: $showingCuriosityMode) {
            CuriosityModeView()
        }
        .sheet(isPresented: $showingDataManagement) {
            SurveyDataExportView()
        }
    }
}

#Preview {
    SurveyAccessView()
}
